/*
 EditMesh Operations MacroScript File
 Version:  3ds max 6
 
 Revision History:
 	11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products


 
 EditMesh operations Macroscript file.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--
-- Renamed flt_EditM --> Filters.Is_EditMesh
*/


MacroScript EMesh_Attach
ButtonText:~EMESH_ATTACH_BUTTONTEXT~
Category:~EMESH_ATTACH_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_ATTACH_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		ApplyOperation Edit_Mesh meshops.startAttach
	
	)

)
MacroScript EMesh_Detach
ButtonText:~EMESH_DETACH_BUTTONTEXT~
Category:~EMESH_DETACH_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_DETACH_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try(ApplyOperation Edit_Mesh meshops.Detach)Catch(MessageBox ~EMESH_DETACH_CAPTION~ Title:~EMESH_DETACH_TITLE~)
		
	)

)
MacroScript EMesh_Weld
ButtonText:~EMESH_WELD_BUTTONTEXT~
Category:~EMESH_WELD_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_WELD_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 1 then subobjectlevel = 1
		
		ApplyOperation Edit_Mesh meshops.Weld
	
	)

)
MacroScript EMesh_Hide
ButtonText:~EMESH_HIDE_BUTTONTEXT~
Category:~EMESH_HIDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_HIDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMeshSpecifyLevel #{2,4..6}

	On Execute Do
	(
		Try(ApplyOperation Edit_Mesh meshops.Hide)Catch(MessageBox ~EMESH_HIDE_CAPTION~ Title:~EMESH_HIDE_TITLE~)
	)

)
MacroScript EMesh_UnHide
ButtonText:~EMESH_UNHIDE_BUTTONTEXT~
Category:~EMESH_UNHIDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_UNHIDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMeshSpecifyLevel #{2,4..6}

	On Execute Do
	(
		Try(ApplyOperation Edit_Mesh meshops.UnHideAll)Catch(MessageBox ~EMESH_UNHIDE_CAPTION~ Title:~EMESH_UNHIDE_TITLE~)
	)
)
MacroScript EMesh_Collapse
ButtonText:~EMESH_COLLAPSE_BUTTONTEXT~
Category:~EMESH_COLLAPSE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_COLLAPSE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		Try(ApplyOperation Edit_Mesh meshops.collapse)Catch(MessageBox ~EMESH_COLLAPSE_CAPTION~ Title:~EMESH_COLLAPSE_TITLE~)
	)
)

MacroScript EMesh_View_Align
ButtonText:~EMESH_VIEW_ALIGN_BUTTONTEXT~
Category:~EMESH_VIEW_ALIGN_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_VIEW_ALIGN_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == 0 then subobjectlevel = 4
		else ApplyOperation Edit_Mesh meshops.viewAlign
	)

)

MacroScript EMesh_Grid_Align
ButtonText:~EMESH_GRID_ALIGN_BUTTONTEXT~
Category:~EMESH_GRID_ALIGN_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_GRID_ALIGN_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(

		Try(ApplyOperation Edit_Mesh meshops.gridAlign)Catch(MessageBox ~EMESH_GRID_ALIGN_CAPTION~ Title:~EMESH_GRID_ALIGN_TITLE~)
	
	)

)
MacroScript EMesh_Make_Planer
ButtonText:~EMESH_MAKE_PLANER_BUTTONTEXT~
Category:~EMESH_MAKE_PLANER_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_MAKE_PLANER_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == 0 then subobjectlevel = 4
		else Try(ApplyOperation Edit_Mesh meshops.MakePlanar)Catch(MessageBox ~EMESH_MAKE_PLANER_CAPTION~ Title:~EMESH_MAKE_PLANER_TITLE~)
	
	)

)
MacroScript EMesh_Flip
ButtonText:~EMESH_FLIP_BUTTONTEXT~
Category:~EMESH_FLIP_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_FLIP_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Mesh meshops.startFlipNormalmode)Catch(MessageBox ~EMESH_FLIP_CAPTION~ Title:~EMESH_FLIP_TITLE~)
	
	)

)
MacroScript EMesh_Unify
ButtonText:~EMESH_UNIFY_BUTTONTEXT~
Category:~EMESH_UNIFY_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_UNIFY_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(

		Try(ApplyOperation Edit_Mesh meshops.Unifynormal)Catch(MessageBox ~EMESH_UNIFY_CAPTION~ Title:~EMESH_UNIFY_TITLE~)
	
	)

)

MacroScript EMesh_Inset
ButtonText:~EMESH_INSET_BUTTONTEXT~
Category:~EMESH_INSET_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_INSET_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(

		Try
		(
			extrudeface $ #selection 0 50
		)Catch(MessageBox ~EMESH_INSET_CAPTION~ Title:~EMESH_INSET_TITLE~)
	
	)

)
-- *******************************************************************
--  Mesh Ops:  Vertex Mode  
--
--  SO LEVELS: 1 = vertex; 2 = edges; 3 = faces; 4 = polygons
--
-- *******************************************************************

MacroScript EMesh_VChamfer
ButtonText:~EMESH_VCHAMFER_BUTTONTEXT~
Category:~EMESH_VCHAMFER_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_VCHAMFER_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		Try
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			ApplyOperation Edit_Mesh meshops.startchamfer
		)
		Catch(MessageBox ~EMESH_VCHAMFER_CAPTION~ Title:~EMESH_VCHAMFER_TITLE~)
	
	)

)
MacroScript EMesh_VCreate
ButtonText:~EMESH_VCREATE_BUTTONTEXT~
Category:~EMESH_VCREATE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_VCREATE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			ApplyOperation Edit_Mesh meshops.startCreate
		)
		Catch(MessageBox ~EMESH_VCREATE_CAPTION~ Title:~EMESH_VCREATE_TITLE~)
	)

)

MacroScript EMesh_VBreak
ButtonText:~EMESH_VBREAK_BUTTONTEXT~
Category:~EMESH_VBREAK_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_VBREAK_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			
			if SubObjectLevel == 1 then ApplyOperation Edit_Mesh meshops.break
			else SubObjectLevel = 1
		)
		Catch(MessageBox ~EMESH_VBREAK_CAPTION~ Title:~EMESH_VBREAK_TITLE~)
	)

)

MacroScript EMesh_RemoveIsolatedVerts
ButtonText:~EMESH_REMOVEISOLATEDVERTS_BUTTONTEXT~
Category:~EMESH_REMOVEISOLATEDVERTS_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_REMOVEISOLATEDVERTS_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			ApplyOperation Edit_Mesh meshops.removeisolatedverts
		)
		Catch(MessageBox ~EMESH_REMOVEISOLATEDVERTS_CAPTION~ Title:~EMESH_REMOVEISOLATEDVERTS_TITLE~)
	)

)

MacroScript EMesh_SlicePlane
ButtonText:~EMESH_SLICEPLANE_BUTTONTEXT~
Category:~EMESH_SLICEPLANE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_SLICEPLANE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 4
			ApplyOperation Edit_Mesh meshops.startsliceplane
		)
		Catch(MessageBox ~EMESH_SLICEPLANE_CAPTION~ Title:~EMESH_SLICEPLANE_TITLE~)
	)

)
MacroScript EMesh_TargetWeld
ButtonText:~EMESH_TARGETWELD_BUTTONTEXT~
Category:~EMESH_TARGETWELD_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_TARGETWELD_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			ApplyOperation Edit_Mesh meshops.startWeldTarget
		)
		Catch(MessageBox ~EMESH_TARGETWELD_CAPTION~ Title:~EMESH_TARGETWELD_TITLE~)
	)

)

-- *******************************************************************
-- Mesh Ops:  Edge Mode 
--
--  SO LEVELS: 1 = vertex; 2 = edges; 3 = faces; 4 = polygons
--
-- *******************************************************************

MacroScript EMesh_EExtrude
ButtonText:~EMESH_EEXTRUDE_BUTTONTEXT~
Category:~EMESH_EEXTRUDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_EEXTRUDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.startExtrude
		)
		Catch(MessageBox ~EMESH_EEXTRUDE_CAPTION~ Title:~EMESH_EEXTRUDE_TITLE~)
	)

)

MacroScript EMesh_EChamfer
ButtonText:~EMESH_ECHAMFER_BUTTONTEXT~
Category:~EMESH_ECHAMFER_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_ECHAMFER_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.startChamfer
		)
		Catch(MessageBox ~EMESH_ECHAMFER_OP_FAILED_TOOLTIP~ Title:~EMESH_ECHAMFER_OP_FAILED_TITLE~)
	)

)

MacroScript EMesh_ECut
ButtonText:~EMESH_ECUT_BUTTONTEXT~
Category:~EMESH_ECUT_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_ECUT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.startCut
		)
		Catch(MessageBox ~EMESH_ECUT_CAPTION~ Title:~EMESH_ECUT_TITLE~)
	)

)


MacroScript EMesh_EDivide
ButtonText:~EMESH_EDIVIDE_BUTTONTEXT~
Category:~EMESH_EDIVIDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_EDIVIDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.startDivide
		)
		Catch(MessageBox ~EMESH_EDIVIDE_CAPTION~ Title:~EMESH_EDIVIDE_TITLE~)
	)

)

MacroScript EMesh_ETurn
ButtonText:~EMESH_ETURN_BUTTONTEXT~
Category:~EMESH_ETURN_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_ETURN_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.startTurn
		)
		Catch(MessageBox ~EMESH_ETURN_CAPTION~ Title:~EMESH_ETURN_TITLE~)
	)

)

MacroScript EMesh_EVisible
ButtonText:~EMESH_EVISIBLE_BUTTONTEXT~
Category:~EMESH_EVISIBLE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_EVISIBLE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.VisibleEdge
		)
		Catch(MessageBox ~EMESH_EVISIBLE_CAPTION~ Title:~EMESH_EVISIBLE_TITLE~)
	)

)

MacroScript EMesh_EInVisible
ButtonText:~EMESH_EINVISIBLE_BUTTONTEXT~
Category:~EMESH_EINVISIBLE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_EINVISIBLE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.InVisibleEdge
		)
		Catch(MessageBox ~EMESH_EINVISIBLE_CAPTION~ Title:~EMESH_EINVISIBLE_TITLE~)
	)

)

MacroScript EMesh_OpenEdges
ButtonText:~EMESH_OPENEDGES_BUTTONTEXT~
Category:~EMESH_OPENEDGES_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_OPENEDGES_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.SelectOpenEdges
		)
		Catch(MessageBox ~EMESH_OPENEDGES_CAPTION~ Title:~EMESH_OPENEDGES_TITLE~)
	)

)

MacroScript EMesh_ShapeFromEdges
ButtonText:~EMESH_SHAPEFROMEDGES_BUTTONTEXT~
Category:~EMESH_SHAPEFROMEDGES_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_SHAPEFROMEDGES_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 2
			ApplyOperation Edit_Mesh meshops.CreateShapeFromEdges
		)
		Catch(MessageBox ~EMESH_SHAPEFROMEDGES_CAPTION~ Title:~EMESH_SHAPEFROMEDGES_TITLE~)
	)

)

-- *******************************************************************
--  Mesh Ops: Face Mode  
--
--  SO LEVELS: 1 = vertex; 2 = edges; 3 = faces; 4 = polygons
--
-- *******************************************************************

MacroScript EMesh_FExtrude
ButtonText:~EMESH_FEXTRUDE_BUTTONTEXT~
Category:~EMESH_FEXTRUDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_FEXTRUDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 3 then subobjectlevel = 3
			ApplyOperation Edit_Mesh meshops.startExtrude
		)
		Catch(MessageBox ~EMESH_FEXTRUDE_CAPTION~ Title:~EMESH_FEXTRUDE_TITLE~)
	)

)

MacroScript EMesh_FBevel
ButtonText:~EMESH_FBEVEL_BUTTONTEXT~
Category:~EMESH_FBEVEL_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_FBEVEL_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 3 then subobjectlevel = 3
			ApplyOperation Edit_Mesh meshops.startBevel
		)
		Catch(MessageBox ~EMESH_FBEVEL_CAPTION~ Title:~EMESH_FBEVEL_TITLE~)
	)

)

MacroScript EMesh_FCreate
ButtonText:~EMESH_FCREATE_BUTTONTEXT~
Category:~EMESH_FCREATE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_FCREATE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 3 then subobjectlevel = 3
			ApplyOperation Edit_Mesh meshops.startCreate
		)
		Catch(MessageBox ~EMESH_FCREATE_CAPTION~ Title:~EMESH_FCREATE_TITLE~)
	)

)

MacroScript EMesh_FCut
ButtonText:~EMESH_FCUT_BUTTONTEXT~
Category:~EMESH_FCUT_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_FCUT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 3 then subobjectlevel = 3
			ApplyOperation Edit_Mesh meshops.startCut
		)
		Catch(MessageBox ~EMESH_FCUT_CAPTION~ Title:~EMESH_FCUT_TITLE~)
	)

)

MacroScript EMesh_FDivide
ButtonText:~EMESH_FDIVIDE_BUTTONTEXT~
Category:~EMESH_FDIVIDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_FDIVIDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 3 then subobjectlevel = 3
			ApplyOperation Edit_Mesh meshops.startDivide
		)
		Catch(MessageBox ~EMESH_FDIVIDE_CAPTION~ Title:~EMESH_FDIVIDE_TITLE~)
	)

)

MacroScript EMesh_FFlip
ButtonText:~EMESH_FFLIP_BUTTONTEXT~
Category:~EMESH_FFLIP_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_FFLIP_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 3 then subobjectlevel = 3
			ApplyOperation Edit_Mesh meshops.startFlipNormalmode
		)
		Catch(MessageBox ~EMESH_FFLIP_CAPTION~ Title:~EMESH_FFLIP_TITLE~)
	)

)

-- *******************************************************************
-- Mesh Ops: Polygon Mode 
--
--  SO LEVELS: 1 = vertex; 2 = edges; 3 = faces; 4 = polygons
--
-- *******************************************************************

MacroScript EMesh_PExtrude
ButtonText:~EMESH_PEXTRUDE_BUTTONTEXT~
Category:~EMESH_PEXTRUDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_PEXTRUDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 4 then subobjectlevel = 4
			ApplyOperation Edit_Mesh meshops.startExtrude
		)
		Catch(MessageBox ~EMESH_PEXTRUDE_CAPTION~ Title:~EMESH_PEXTRUDE_TITLE~)
	)

)

MacroScript EMesh_PCreate
ButtonText:~EMESH_PCREATE_BUTTONTEXT~
Category:~EMESH_PCREATE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_PCREATE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 4 then subobjectlevel = 4
			ApplyOperation Edit_Mesh meshops.startCreate
		)
		Catch(MessageBox ~EMESH_PCREATE_CAPTION~ Title:~EMESH_PCREATE_TITLE~)
	)

)

MacroScript EMesh_PExtrude
ButtonText:~EMESH_EXTRUDE_POLYGONS_BUTTONTEXT~
Category:~EMESH_EDITABLE_MESH_OBJECT_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_EXTRUDE_POLYGONS_MESH_TOOLTIP~
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 4 then subobjectlevel = 4
			ApplyOperation Edit_Mesh meshops.startExtrude
		)
		Catch(MessageBox ~EMESH_PEXTRUDE_OP_FAILED_CAPTION~ Title:~EMESH_PEXTRUDE_OP_FAILED_TITLE~)
	)

)

MacroScript EMesh_PCut
ButtonText:~EMESH_PCUT_BUTTONTEXT~
Category:~EMESH_PCUT_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_PCUT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 4 then subobjectlevel = 4
			ApplyOperation Edit_Mesh meshops.startCut
		)
		Catch(MessageBox ~EMESH_PCUT_CAPTION~ Title:~EMESH_PCUT_TITLE~)
	)

)


MacroScript EMesh_PDivide
ButtonText:~EMESH_PDIVIDE_BUTTONTEXT~
Category:~EMESH_PDIVIDE_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_PDIVIDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 4 then subobjectlevel = 4
			ApplyOperation Edit_Mesh meshops.startDivide
		)
		Catch(MessageBox ~EMESH_PDIVIDE_CAPTION~ Title:~EMESH_PDIVIDE_TITLE~)
	)

)

MacroScript EMesh_PBevel
ButtonText:~EMESH_PBEVEL_BUTTONTEXT~
Category:~EMESH_PBEVEL_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_PBEVEL_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 4 then subobjectlevel = 4
			ApplyOperation Edit_Mesh meshops.startBevel
		)
		Catch(MessageBox ~EMESH_PBEVEL_CAPTION~ Title:~EMESH_PBEVEL_TITLE~)
	)

)

MacroScript EMesh_PFlip
ButtonText:~EMESH_PFLIP_BUTTONTEXT~
Category:~EMESH_PFLIP_CATEGORY~ 
internalCategory:"Editable Mesh Object" 
Tooltip:~EMESH_PFLIP_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditMesh()
	On IsVisible Return Filters.Is_EditMesh()

	On Execute Do
	(
		
		Try	
		(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 4 then subobjectlevel = 4
			ApplyOperation Edit_Mesh meshops.startFlipNormalMode
		)
		Catch(MessageBox ~EMESH_PFLIP_CAPTION~ Title:~EMESH_PFLIP_TITLE~)
	)

)







